Name:		tdiff
Version:	0.8.9
Release:	1%{?dist}
Summary:	Compare tree permissions, modes, ownership, xattrs, etc

License:	GPLv3
URL:		https://github.com/F-i-f/%{name}
Source:		https://github.com/F-i-f/%{name}/releases/download/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:	zsh
BuildRequires:	bash
BuildRequires:	gcc
BuildRequires:	make
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	libacl-devel
%if 0%{?rhel} == 0
BuildRequires:	fakeroot
%endif

# Work-around for Mageia mucking with config.aux files
%if 0%{?mgaversion} > 0
%define _disable_libtoolize 1
%endif

%description
Compare file system trees, showing any differences in their:
  - file size,
  - file block count (physical storage size),
  - owner user and group ids (uid & gid),
  - access, modification and inode change times,
  - hard link count, and sets of hard linked files,
  - extended attributes (if supported),
  - ACLs (if supported).

%prep
%setup -q

%build
%configure --enable-compiler-warnings --docdir="%{_docdir}/%{name}"
make %{?_smp_mflags}
make %{?_smp_mflags} check || ( ./tests-show-results ; exit 1 )

%install
rm -rf $RPM_BUILD_ROOT
%make_install

%files
%{_bindir}/tdiff
%{_mandir}/man1/tdiff.1*
%{_datadir}/bash-completion/completions/tdiff
%{_datadir}/zsh/site-functions/_tdiff
%{_docdir}/%{name}

%changelog
* Wed Oct 22 2025 Philippe Troin  <phil@fifi.org> - 0.8.9-1
- Upstream release 0.8.9.
  * Android builds could fail because of an unused static function.
  * Code refactoring and cleanups.

* Wed Oct 22 2025 Philippe Troin  <phil@fifi.org> - 0.8.8-1
- Upstream release 0.8.8.
  * An excluded but missing file caused tdiff to exit with a failure
    code.
  * Memory corruption could occur if a symlink target string size is a
    multiple of 1024 (unlikely, symlink lengths are typically limited to
    1024 or less).
  * Regressions (`make check`) now run without errors on MacOSX.
  * Code refactoring and cleanups.
  * Open files at most once (speedup).
  * m4 macros have been moved to a sub-module.

* Tue Jan 30 2024 Philippe Troin <phil@fifi.org> - 0.8.7-1
- Don't presume man file compression style.
- Upstream release 0.8.7.
  * Ignore `trusted.SGI_ACL_DEFAULT` default ACL (XFS-specific).
  * Do not update access time when comparing symbolic-link
    (system-dependent, Linux only).
  * Compare ACLs faster if acl_cmp() is available.
  * Improve test suite portability on *BSD.
  * Android build now defaults to statically linked executable.
  * Test suite skips some time and block related tests on problem
    platforms.

* Sat May 21 2022 Philippe Troin <phil@fifi.org> - 0.8.6-1
- Upstream release 0.8.6:
  * Handle mallinfo2 and glibc 2.34.

* Sun Nov  3 2019 Philippe Troin <phil@fifi.org> - 0.8.5-2
- Fix build on RHEL which does not have fakeroot.

* Sat Nov  2 2019 Philippe Troin <phil@fifi.org> - 0.8.5-1
- Upstream release 0.8.5:
  * Minor bug fixes terminal width handling.
  * Improvements in .spec cross-distribution compatibility.

* Sun Aug 25 2019 Philippe Troin <phil@fifi.org> - 0.8.4-3
- Add to BuildRequires.
- Configure with --docdir for non-RHEL/Fedora distributions.
- Run test-show-results upon failure.

* Sun Aug 25 2019 Philippe Troin <phil@fifi.org> - 0.8.4-2
- BuildRequires zsh.
- Use URL in Source.

* Fri Jun 14 2019 Philippe Troin <phil@fifi.org> - 0.8.4-1
- Upstream updated to 0.8.4.

* Wed May 22 2019 Philippe Troin <phil@fifi.org> - 0.8.3-1
- Upstream updated to 0.8.3.

* Sun May 12 2019 Philippe Troin <phil@fifi.org> - 0.8.2-1
- Upstream updated to 0.8.2.

* Tue May  7 2019 Philippe Troin <phil@fifi.org> - 0.8.1-1
- Upstream updated to 0.8.1.
- BuildRequires fakeroot.

* Fri May  3 2019 Philippe Troin <phil@fifi.org> - 0.8-1
- Upstream updated to 0.8.
- Update description.
- Rely on make install to install documentation files.

* Tue Apr 30 2019 Philippe Troin <phil@fifi.org> - 0.7.2-1
- Upstream updated to 0.7.2.

* Sat Apr 27 2019 Philippe Troin <phil@fifi.org> - 0.7.1-1
- Upstream updated to 0.7.1.

* Fri Apr 26 2019 Philippe Troin <phil@fifi.org> - 0.7-1
- Upstream updated to 0.7.
- Install manpage, more documentation.

* Tue Mar 12 2019 Philippe Troin <phil@fifi.org> - 0.2.99.WIP-1.git_0.2+34.g7efe9c0
- Snapshot from github.
- Install bash and zsh completions.

* Mon Feb  3 2014 Philippe Troin <phil@fifi.org> - 0.2-1
- Created.
